/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.function.Function;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class SimpleIdMapping<C, I>
implements IdMapping<C, I> {
    private final AccessorWrapperIdAccessor<C, I> idAccessor;
    private final IdentifierInsertionManager<C, I> identifierInsertionManager;
    private final PersistExecutor.DefaultPersistExecutor.DefaultIsNewDeterminer<C> isNewDeterminer;
    private final SingleIdentifierAssembler<I, ?> identifierMarshaller;

    public SimpleIdMapping(AccessorWrapperIdAccessor<C, I> idAccessor, IdentifierInsertionManager<C, I> identifierInsertionManager, SingleIdentifierAssembler<I, ?> identifierMarshaller) {
        this.idAccessor = idAccessor;
        this.identifierInsertionManager = identifierInsertionManager;
        this.identifierMarshaller = identifierMarshaller;
        this.isNewDeterminer = identifierInsertionManager instanceof AlreadyAssignedIdentifierManager ? new AlreadyAssignedIdDeterminer(((AlreadyAssignedIdentifierManager)identifierInsertionManager).getIsPersistedFunction()) : (identifierInsertionManager.getIdentifierType().isPrimitive() ? new PrimitiveIdDeterminer() : new NullableIdDeterminer());
    }

    public SimpleIdMapping(ReversibleAccessor<C, I> identifierAccessor, IdentifierInsertionManager<C, I> identifierInsertionManager, SingleIdentifierAssembler identifierMarshaller) {
        this(new AccessorWrapperIdAccessor<C, I>(identifierAccessor), identifierInsertionManager, identifierMarshaller);
    }

    @Override
    public AccessorWrapperIdAccessor<C, I> getIdAccessor() {
        return this.idAccessor;
    }

    @Override
    public IdentifierInsertionManager<C, I> getIdentifierInsertionManager() {
        return this.identifierInsertionManager;
    }

    @Override
    public boolean isNew(C entity) {
        return this.isNewDeterminer.isNew(entity);
    }

    @Override
    public <T extends Table<T>> SingleIdentifierAssembler<I, T> getIdentifierAssembler() {
        return this.identifierMarshaller;
    }

    private class AlreadyAssignedIdDeterminer
    extends PersistExecutor.DefaultPersistExecutor.DefaultIsNewDeterminer<C> {
        private final Function<C, Boolean> isPersistedFunction;

        private AlreadyAssignedIdDeterminer(Function<C, Boolean> isPersistedFunction) {
            this.isPersistedFunction = isPersistedFunction;
        }

        @Override
        public boolean isNew(C entity) {
            return this.isPersistedFunction.apply(entity) == false;
        }
    }

    private class PrimitiveIdDeterminer
    extends PersistExecutor.DefaultPersistExecutor.DefaultIsNewDeterminer<C> {
        private PrimitiveIdDeterminer() {
        }

        @Override
        public boolean isNew(C entity) {
            return ((Number)SimpleIdMapping.this.idAccessor.getId(entity)).intValue() == 0;
        }
    }

    private class NullableIdDeterminer
    extends PersistExecutor.DefaultPersistExecutor.DefaultIsNewDeterminer<C> {
        private NullableIdDeterminer() {
        }

        @Override
        public boolean isNew(C entity) {
            return SimpleIdMapping.this.idAccessor.getId(entity) == null;
        }
    }
}

